#include <iostream>
#include <queue>
#include <vector>
#include <climits>
using namespace std;

struct Node {
    int cost, x, y;
    bool operator>(const Node& other) const {
        return cost > other.cost;
    }
};

int main() {
    while (true) {
        int L, C, T;
        cin >> L >> C >> T;
        if (L == 0 && C == 0 && T == 0) break;

        vector<vector<int>> grid(L, vector<int>(C));
        for (int i = 0; i < L; i++) {
            for (int j = 0; j < C; j++) {
                cin >> grid[i][j];
            }
        }

        int L1, C1, L2, C2;
        cin >> L1 >> C1 >> L2 >> C2;
        L1--; C1--; L2--; C2--;

        vector<vector<int>> dist(L, vector<int>(C, INT_MAX));
        vector<vector<bool>> vis(L, vector<bool>(C, false));

        priority_queue<Node, vector<Node>, greater<Node>> pq;
        dist[L1][C1] = grid[L1][C1];
        pq.push({grid[L1][C1], L1, C1});

        int dir[4][2] = {{0, 1}, {1, 0}, {0, -1}, {-1, 0}};

        while (!pq.empty()) {
            Node node = pq.top();
            pq.pop();

            int x = node.x, y = node.y;

            if (vis[x][y]) continue;
            vis[x][y] = true;

            for (int i = 0; i < 4; i++) {
                int a = x + dir[i][0], b = y + dir[i][1];
                if (a < 0 || a >= L || b < 0 || b >= C || grid[a][b] == -1 || vis[a][b]) {
                    continue;
                }
                if (dist[a][b] > dist[x][y
